// Lab.11: Identify the parameters of a discrete time system using
// non-recursive LS method.

xdel(winsid()); //close all graphics Windows clear ;
clear;
clc ;
//-------------------------------------------------------------
//system model
s=poly(0,'s');
num=s+1;
den=s^2+1.6*s+1;
sys=syslin('c', num/den);
//-------------------------------------------------------------
//Discretization of a given system
Ts=0.2;   //Sampling time
sysd=dscr(sys,Ts);
sysd_tf=ss2tf(sysd);
//--------------------------------------------------------------
//System Identification
t=0:Ts:2;
//ramp inputis used as with the step input psi becomes singular,
//because input columns in psi are repeated 
u=t;
y=flts(u,sysd_tf);

for i=1:1:5
Y(i)=y(i+3);
psi(i,1:4)=[-y(i+2) -y(i+1) u(i+2) u(i+1)];
end 
theta=inv(psi'*psi)*psi'*Y;
//identified system
num=[theta([4,3])];
den=[theta([2,1]); 1];
num_z=poly(num,'z','coeff')
den_z=poly(den,'z','coeff')
sysd_id=num_z/den_z;
disp(sysd_tf,'sysd_tf=','The discrete model of the system is');
disp(sysd_tf,'sysd_id=','The identified system is');
//--------------------------------------------------------------

